<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Promotion
 * 
 * @property int $promotion_id
 * @property string|null $promotion_designation
 * @property int|null $promotion_type_id
 * @property int $par
 * @property Carbon|null $date_debut
 * @property Carbon|null $date_fin
 * @property int|null $status
 * @property int|null $zone_id
 * @property int|null $entreprise_id
 * @property int|null $depot_id
 * @property int|null $valeur_commande_min
 * @property int|null $valeur_commande_max
 * @property int|null $valeur_commande_quantite
 * @property int|null $valeur_gratuite
 *
 * @package App\Models
 */
class Promotion extends Model
{
	protected $table = 'promotion';
	protected $primaryKey = 'promotion_id';
	public $timestamps = false;

	protected $casts = [
		'promotion_type_id' => 'int',
		'par' => 'int',
		'status' => 'int',
		'zone_id' => 'int',
		'entreprise_id' => 'int',
		'depot_id' => 'int',
		'valeur_commande_min' => 'int',
		'valeur_commande_max' => 'int',
		'valeur_commande_quantite' => 'int',
		'valeur_gratuite' => 'int'
	];

	protected $dates = [
		'date_debut',
		'date_fin'
	];

	protected $fillable = [
		'promotion_designation',
		'promotion_type_id',
		'par',
		'date_debut',
		'date_fin',
		'status',
		'zone_id',
		'entreprise_id',
		'depot_id',
		'valeur_commande_min',
		'valeur_commande_max',
		'valeur_commande_quantite',
		'valeur_gratuite'
	];
}
