<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class PromotionDetail
 * 
 * @property int $promotion_detail_id
 * @property string|null $promotion_detail_code
 * @property int|null $promotion_id
 * @property int|null $promotion_article_id
 * @property string|null $promotion_article_designation
 * @property float|null $promotion_article_quantite
 * @property int|null $promotion_article_unite
 * @property float|null $prix_total_ht
 * @property float|null $prix_unitaire_ht
 * @property float|null $montant_remise
 * @property float|null $montant_HT
 * @property float|null $montant_TVA
 * @property float|null $montant_TTC
 * @property float|null $new_montant_ttc
 * @property float|null $taux_remise
 * @property int $promotion_detail_type_id
 * @property int|null $promotion_niveau_id
 *
 * @package App\Models
 */
class PromotionDetail extends Model
{
	protected $table = 'promotion_detail';
	protected $primaryKey = 'promotion_detail_id';
	public $timestamps = false;

	protected $casts = [
		'promotion_id' => 'int',
		'promotion_article_id' => 'int',
		'promotion_article_quantite' => 'float',
		'promotion_article_unite' => 'int',
		'prix_total_ht' => 'float',
		'prix_unitaire_ht' => 'float',
		'montant_remise' => 'float',
		'montant_HT' => 'float',
		'montant_TVA' => 'float',
		'montant_TTC' => 'float',
		'new_montant_ttc' => 'float',
		'taux_remise' => 'float',
		'promotion_detail_type_id' => 'int',
		'promotion_niveau_id' => 'int'
	];

	protected $fillable = [
		'promotion_detail_code',
		'promotion_id',
		'promotion_article_id',
		'promotion_article_designation',
		'promotion_article_quantite',
		'promotion_article_unite',
		'prix_total_ht',
		'prix_unitaire_ht',
		'montant_remise',
		'montant_HT',
		'montant_TVA',
		'montant_TTC',
		'new_montant_ttc',
		'taux_remise',
		'promotion_detail_type_id',
		'promotion_niveau_id'
	];
}
