<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class PromotionOld
 * 
 * @property int $promotion_id
 * @property int|null $article_id
 * @property string $promotion_designation
 * @property int|null $promotion_type_id
 * @property Carbon|null $date_debut
 * @property Carbon|null $date_fin
 * @property int|null $promotion_status_id
 * @property string|null $promotion_reference
 * @property float|null $promotion_montant
 * @property float $promotion_montant_habituel
 * @property float|null $promotion_ecart
 * @property int|null $max_client
 * @property int $validation
 * @property int|null $quantite
 *
 * @package App\Models
 */
class PromotionOld extends Model
{
	protected $table = 'promotion_old';
	protected $primaryKey = 'promotion_id';
	public $timestamps = false;

	protected $casts = [
		'article_id' => 'int',
		'promotion_type_id' => 'int',
		'promotion_status_id' => 'int',
		'promotion_montant' => 'float',
		'promotion_montant_habituel' => 'float',
		'promotion_ecart' => 'float',
		'max_client' => 'int',
		'validation' => 'int',
		'quantite' => 'int'
	];

	protected $dates = [
		'date_debut',
		'date_fin'
	];

	protected $fillable = [
		'article_id',
		'promotion_designation',
		'promotion_type_id',
		'date_debut',
		'date_fin',
		'promotion_status_id',
		'promotion_reference',
		'promotion_montant',
		'promotion_montant_habituel',
		'promotion_ecart',
		'max_client',
		'validation',
		'quantite'
	];
}
